*-------------------------------------------------------------------------------
/* title : Compute upstreamness measure following:
		   Fally (2011); and Antras, Chor, Fally & Hillberry (2012). 
		   The code used is based on Antras, Chor, Fally & Hillberry (2012).
   source: World Input-Output Tables, 2016 Release (in Stata format)
		   http://www.wiod.org/database/wiots16	 
   input : $data/wiot_stata_Nov16/WIOT`year'_October16_ROW.dta
   output: $output_fig/OnlineAppendix_FigureD7 */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd												// Current directory of code
do "[0.0] directories.do"

*===============================================================================
* Upstreameness measure: Fally (2011); Antras, Chor, Fally & Hillberry (2012)
*===============================================================================

*--------------------Considering each country seperately------------------------
use "$data/wiot_stata_Nov16/WIOT2000_October16_ROW.dta", clear
rename RNr CPA
rename Year year
rename Country country
keep CPA year country
gen UP = 0
save "$temp/Upstreamness", replace 

qui foreach country in AUT BEL BGR CZE DEU ESP EST FIN FRA HRV HUN ITA NOR POL PRT ROU SWE SVK SVN { 

	forvalues y = 2000/2014 {

		use "$data/wiot_stata_Nov16/WIOT`y'_October16_ROW.dta", clear
		drop if Country=="TOT"
		drop if Country!="`country'"
		rename RNr CPA
		rename Country country
		rename Year year
		keep country year IndustryCode IndustryDescription CPA *`country'* TOT
		
		forvalues x = 1/56 {
			gen v`x'EXC`country' = 0
			foreach i in AUT BEL DEU DNK ESP FIN FRA GBR GRC IRL ITA NLD NOR PRT SWE BGR CZE EST HRV HUN LTU LVA POL ROU SVK SVN ///
						 AUS BRA CAN CHE CHN CYP IDN IND JPN KOR LUX MEX MLT RUS TUR TWN USA ROW { 
				if country!="`country'" {
					replace v`x'EXC`country' = v`x'EXC`country'+v`i'`x' 
				}
			}
		}
		
		foreach x in 57 58 59 60 61 {
			gen v`x'EXC`country' = 0
			foreach i in AUT BEL DEU DNK ESP FIN FRA GBR GRC IRL ITA NLD NOR PRT SWE BGR CZE EST HRV HUN LTU LVA POL ROU SVK SVN ///
						 AUS BRA CAN CHE CHN CYP IDN IND JPN KOR LUX MEX MLT RUS TUR TWN USA ROW { 
				if country!="`country'" {
					replace v`x'EXC`country' = v`x'EXC`country'+v`i'`x'
				}
			}
		}

		gen IntEXC`country' = 0 //EXPORTS of intermediate inputs
		forvalues x = 1/56 {
			replace IntEXC`country' = IntEXC`country'+v`x'EXC`country'
		}

		gen goinv = 1/(TOT-IntEXC`country'-v57EXC`country'-v58EXC`country'-v59EXC`country'-v60EXC`country'-v61EXC`country')
		replace goinv = 0 if goinv==.
		mkmat goinv, rownames(CPA)

		clear
		use "$data/wiot_stata_Nov16/WIOT`y'_October16_ROW.dta", clear
		drop if Country=="TOT"
		drop if Country!="`country'"
		rename RNr CPA
		rename Country country
		rename Year year
		keep country year IndustryCode IndustryDescription CPA *`country'*
		
		* To make the IOtable
		forvalues x = 1/56 {
			gen v`x' = 0
			foreach i in AUT BEL DEU DNK ESP FIN FRA GBR GRC IRL ITA NLD NOR PRT SWE BGR CZE EST HRV HUN LTU LVA POL ROU SVK SVN ///
						 AUS BRA CAN CHE CHN CYP IDN IND JPN KOR LUX MEX MLT RUS TUR TWN USA ROW { 
				if country!="`country'" {
					replace v`x' = v`x'+v`i'`x'
				}
			}
		}

		keep CPA v`country'1-v`country'56
		mkmat    v`country'1-v`country'56, matrix(tot) rownames(CPA)
		matrix phi = diag(goinv)*tot
		gen ones = 1
		mkmat ones, matrix(ones) rownames(CPA)
		matrix distance = inv(I(56)-phi)*ones
		keep CPA
		svmat distance, names(UP)
		rename UP1 UP
		replace UP = . if UP==1
		hashsort CPA
		gen year = `y'
		gen country = "`country'"
		append using "$temp/Upstreamness"
		drop if UP==0
		label variable UP "Following Fally2011 and Antras,Chor,Fally&Hillberry2012"
		hashsort CPA
		save "$temp/Upstreamness", replace 
	}
}

* Country names
replace country = "AT" if country=="AUT"
replace country = "BE" if country=="BEL"
replace country = "BG" if country=="BGR"
replace country = "CZ" if country=="CZE"
replace country = "DE" if country=="DEU"
replace country = "ES" if country=="ESP"
replace country = "EE" if country=="EST"
replace country = "FI" if country=="FIN"
replace country = "FR" if country=="FRA"
replace country = "HR" if country=="HRV"
replace country = "HU" if country=="HUN"
replace country = "IT" if country=="ITA"
replace country = "NO" if country=="NOR"
replace country = "PL" if country=="POL"
replace country = "PT" if country=="PRT"
replace country = "RO" if country=="ROU"
replace country = "SK" if country=="SVK"
replace country = "SI" if country=="SVN"
replace country = "SE" if country=="SWE"

* Keep manufacturing sector
keep if inrange(CPA, 5, 23)
sort UP
save "$temp/Upstreamness", replace 


*---------------Considering sample countries as one block - EU------------------
use "$data/wiot_stata_Nov16/WIOT2000_October16_ROW.dta", clear
rename RNr CPA
rename Year year
rename Country country
keep CPA year country
gen UP = 0
save "$temp/Upstreamness_EU", replace 

qui foreach country in EU { 

	forvalues y = 2000/2014 {

		use "$data/wiot_stata_Nov16/WIOT`y'_October16_ROW.dta", clear
		foreach c in AUT BEL BGR CZE DEU ESP EST FIN FRA HRV HUN ITA NOR POL PRT ROU SWE SVK SVN { 
			replace Country = "EU" if Country=="`c'"
		}
		forvalues x = 1/61 {
			gen vEU`x' = 0
			foreach i in AUT BEL BGR CZE DEU ESP EST FIN FRA HRV HUN ITA NOR POL PRT ROU SWE SVK SVN { 
					replace vEU`x' = vEU`x'+v`i'`x' 
					drop v`i'`x'
			}
		}
		gcollapse vEU1-vEU61 TOT, by(IndustryCode IndustryDescription Country RNr Year) 
		drop if Country=="TOT"
		drop if Country!="`country'"
		rename RNr CPA
		rename Country country
		rename Year year
		keep country year IndustryCode IndustryDescription CPA *`country'* TOT
		
		forvalues x = 1/56 {
			gen v`x'EXC`country' = 0
			foreach i in EU AUT BEL DEU DNK ESP FIN FRA GBR GRC IRL ITA NLD NOR PRT SWE BGR CZE EST HRV HUN LTU LVA POL ROU SVK SVN ///
						 AUS BRA CAN CHE CHN CYP IDN IND JPN KOR LUX MEX MLT RUS TUR TWN USA ROW { 
				if country!="`country'" {
					replace v`x'EXC`country' = v`x'EXC`country'+v`i'`x' 
				}
			}
		}
		
		foreach x in 57 58 59 60 61 {
			gen v`x'EXC`country' = 0
			foreach i in EU AUT BEL DEU DNK ESP FIN FRA GBR GRC IRL ITA NLD NOR PRT SWE BGR CZE EST HRV HUN LTU LVA POL ROU SVK SVN ///
						 AUS BRA CAN CHE CHN CYP IDN IND JPN KOR LUX MEX MLT RUS TUR TWN USA ROW { 
				if country!="`country'" {
					replace v`x'EXC`country' = v`x'EXC`country'+v`i'`x'
				}
			}
		}

		gen IntEXC`country' = 0 //EXPORTS of intermediate inputs
		forvalues x = 1/56 {
			replace IntEXC`country' = IntEXC`country'+v`x'EXC`country'
		}

		gen goinv = 1/(TOT-IntEXC`country'-v57EXC`country'-v58EXC`country'-v59EXC`country'-v60EXC`country'-v61EXC`country')
		replace goinv = 0 if goinv ==.
		mkmat goinv, rownames(CPA)

		clear
		use "$data/wiot_stata_Nov16/WIOT`y'_October16_ROW.dta", clear
		foreach c in AUT BEL BGR CZE DEU ESP EST FIN FRA HRV HUN ITA NOR POL PRT ROU SWE SVK SVN { 
			replace Country = "EU" if Country=="`c'"
		}

		forvalues x = 1/61 {
			gen vEU`x' = 0
			foreach i in AUT BEL BGR CZE DEU ESP EST FIN FRA HRV HUN ITA NOR POL PRT ROU SWE SVK SVN { 
					replace vEU`x' = vEU`x'+v`i'`x' 
					drop v`i'`x'
			}
		}
		gcollapse vEU1-vEU61 TOT, by(IndustryCode IndustryDescription Country RNr Year) 
		drop if Country=="TOT"
		drop if Country!="`country'"
		rename RNr CPA
		rename Country country
		rename Year year
		keep country year IndustryCode IndustryDescription CPA *`country'*
		
		* To make the IOtable
		forvalues x = 1/56 {
			gen v`x' = 0
			foreach i in EU AUT BEL DEU DNK ESP FIN FRA GBR GRC IRL ITA NLD NOR PRT SWE BGR CZE EST HRV HUN LTU LVA POL ROU SVK SVN ///
						 AUS BRA CAN CHE CHN CYP IDN IND JPN KOR LUX MEX MLT RUS TUR TWN USA ROW { 
				if country!="`country'" {
					replace v`x' = v`x'+v`i'`x'
				}
			}
		}

		keep CPA v`country'1-v`country'56
		mkmat    v`country'1-v`country'56, matrix(tot) rownames(CPA)
		matrix phi = diag(goinv)*tot
		gen ones = 1
		mkmat ones, matrix(ones) rownames(CPA)
		matrix distance = inv(I(56)-phi)*ones
		keep CPA
		svmat distance, names(UP)
		rename UP1 UP
		replace UP = . if UP==1
		hashsort CPA
		gen year = `y'
		gen country = "`country'"
		append using "$temp/Upstreamness_EU"
		drop if UP==0
		label variable UP "Following Fally2011 and Antras,Chor,Fally&Hillberry2012 at the EU-level"
		hashsort CPA
		save "$temp/Upstreamness_EU", replace 
	}
}

* Keep manufacturing sector
keep if inrange(CPA, 5, 23)
rename UP UP_EU
label variable UP_EU "Following Fally2011 and Antras,Chor,Fally&Hillberry2012 at the EU-level"
hashsort UP_EU
drop country
save "$temp/Upstreamness_EU", replace 


* Merge datasets 
use "$temp/Upstreamness", clear
merge m:1 CPA year using "$temp/Upstreamness_EU", nogen
erase "$temp/Upstreamness_EU.dta" 
gegen UPj = mean(UP), by(CPA)
gegen UPj_EU = mean(UP_EU), by(CPA)
hashsort CPA year country
order country year CPA UP UP_EU UPj UPj_EU
compress
save "$temp/Upstreamness.dta", replace 

*===============================================================================
*Online Appendix Table D7 - Summary statistics of upstreamness measure
*===============================================================================
use "$temp/Upstreamness.dta", clear
gcollapse UPj*, by(CPA)
gegen rank_UPj = rank(UPj)
gegen rank_UPj_EU = rank(UPj_EU)
estpost tabstat CPA UPj_EU UPj, by(rank_UPj_EU) stats(mean) nototal 
estout . using "$output_tex/OnlineAppendix_TableD7.tex", replace 	///
		style(tex) mlabels(,none) collabels(,none) eqlabels(,none) 	///
		cells("CPA(fmt(%9.3g)) UPj_EU(fmt(2)) UPj(fmt(2))")
